# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.add_sign_instance_request import AddSignInstanceRequest
from ..model.add_sign_instance_response import AddSignInstanceResponse
from ..model.cancel_instance_request import CancelInstanceRequest
from ..model.cancel_instance_response import CancelInstanceResponse
from ..model.cc_instance_request import CcInstanceRequest
from ..model.cc_instance_response import CcInstanceResponse
from ..model.create_instance_request import CreateInstanceRequest
from ..model.create_instance_response import CreateInstanceResponse
from ..model.get_instance_request import GetInstanceRequest
from ..model.get_instance_response import GetInstanceResponse
from ..model.list_instance_request import ListInstanceRequest
from ..model.list_instance_response import ListInstanceResponse
from ..model.preview_instance_request import PreviewInstanceRequest
from ..model.preview_instance_response import PreviewInstanceResponse
from ..model.query_instance_request import QueryInstanceRequest
from ..model.query_instance_response import QueryInstanceResponse
from ..model.search_cc_instance_request import SearchCcInstanceRequest
from ..model.search_cc_instance_response import SearchCcInstanceResponse
from ..model.specified_rollback_instance_request import SpecifiedRollbackInstanceRequest
from ..model.specified_rollback_instance_response import SpecifiedRollbackInstanceResponse


class Instance(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def add_sign(self, request: AddSignInstanceRequest,
                 option: Optional[RequestOption] = None) -> AddSignInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddSignInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), AddSignInstanceResponse)
        response.raw = resp

        return response

    async def aadd_sign(self, request: AddSignInstanceRequest,
                        option: Optional[RequestOption] = None) -> AddSignInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddSignInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), AddSignInstanceResponse)
        response.raw = resp

        return response

    def cancel(self, request: CancelInstanceRequest, option: Optional[RequestOption] = None) -> CancelInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CancelInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CancelInstanceResponse)
        response.raw = resp

        return response

    async def acancel(self, request: CancelInstanceRequest,
                      option: Optional[RequestOption] = None) -> CancelInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CancelInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CancelInstanceResponse)
        response.raw = resp

        return response

    def cc(self, request: CcInstanceRequest, option: Optional[RequestOption] = None) -> CcInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CcInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CcInstanceResponse)
        response.raw = resp

        return response

    async def acc(self, request: CcInstanceRequest, option: Optional[RequestOption] = None) -> CcInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CcInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CcInstanceResponse)
        response.raw = resp

        return response

    def create(self, request: CreateInstanceRequest, option: Optional[RequestOption] = None) -> CreateInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateInstanceResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateInstanceRequest,
                      option: Optional[RequestOption] = None) -> CreateInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateInstanceResponse)
        response.raw = resp

        return response

    def get(self, request: GetInstanceRequest, option: Optional[RequestOption] = None) -> GetInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), GetInstanceResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetInstanceRequest, option: Optional[RequestOption] = None) -> GetInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), GetInstanceResponse)
        response.raw = resp

        return response

    def list(self, request: ListInstanceRequest, option: Optional[RequestOption] = None) -> ListInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), ListInstanceResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListInstanceRequest, option: Optional[RequestOption] = None) -> ListInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), ListInstanceResponse)
        response.raw = resp

        return response

    def preview(self, request: PreviewInstanceRequest,
                option: Optional[RequestOption] = None) -> PreviewInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PreviewInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), PreviewInstanceResponse)
        response.raw = resp

        return response

    async def apreview(self, request: PreviewInstanceRequest,
                       option: Optional[RequestOption] = None) -> PreviewInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PreviewInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), PreviewInstanceResponse)
        response.raw = resp

        return response

    def query(self, request: QueryInstanceRequest, option: Optional[RequestOption] = None) -> QueryInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryInstanceResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryInstanceRequest,
                     option: Optional[RequestOption] = None) -> QueryInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryInstanceResponse)
        response.raw = resp

        return response

    def search_cc(self, request: SearchCcInstanceRequest,
                  option: Optional[RequestOption] = None) -> SearchCcInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchCcInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCcInstanceResponse)
        response.raw = resp

        return response

    async def asearch_cc(self, request: SearchCcInstanceRequest,
                         option: Optional[RequestOption] = None) -> SearchCcInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchCcInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCcInstanceResponse)
        response.raw = resp

        return response

    def specified_rollback(self, request: SpecifiedRollbackInstanceRequest,
                           option: Optional[RequestOption] = None) -> SpecifiedRollbackInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SpecifiedRollbackInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     SpecifiedRollbackInstanceResponse)
        response.raw = resp

        return response

    async def aspecified_rollback(self, request: SpecifiedRollbackInstanceRequest,
                                  option: Optional[RequestOption] = None) -> SpecifiedRollbackInstanceResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SpecifiedRollbackInstanceResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     SpecifiedRollbackInstanceResponse)
        response.raw = resp

        return response
