# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .coordinate import Coordinate


class Area(object):
    _types = {
        "type": str,
        "center": Coordinate,
        "radius": int,
        "coords": List[Coordinate],
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.center: Optional[Coordinate] = None
        self.radius: Optional[int] = None
        self.coords: Optional[List[Coordinate]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AreaBuilder":
        return AreaBuilder()


class AreaBuilder(object):
    def __init__(self) -> None:
        self._area = Area()

    def type(self, type: str) -> "AreaBuilder":
        self._area.type = type
        return self

    def center(self, center: Coordinate) -> "AreaBuilder":
        self._area.center = center
        return self

    def radius(self, radius: int) -> "AreaBuilder":
        self._area.radius = radius
        return self

    def coords(self, coords: List[Coordinate]) -> "AreaBuilder":
        self._area.coords = coords
        return self

    def build(self) -> "Area":
        return self._area
