# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ChildItem(object):
    _types = {
        "code": str,
        "value": str,
        "title": str,
        "column_type": int,
        "read_only": bool,
        "min_value": str,
        "max_value": str,
    }

    def __init__(self, d=None):
        self.code: Optional[str] = None
        self.value: Optional[str] = None
        self.title: Optional[str] = None
        self.column_type: Optional[int] = None
        self.read_only: Optional[bool] = None
        self.min_value: Optional[str] = None
        self.max_value: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChildItemBuilder":
        return ChildItemBuilder()


class ChildItemBuilder(object):
    def __init__(self) -> None:
        self._child_item = ChildItem()

    def code(self, code: str) -> "ChildItemBuilder":
        self._child_item.code = code
        return self

    def value(self, value: str) -> "ChildItemBuilder":
        self._child_item.value = value
        return self

    def title(self, title: str) -> "ChildItemBuilder":
        self._child_item.title = title
        return self

    def column_type(self, column_type: int) -> "ChildItemBuilder":
        self._child_item.column_type = column_type
        return self

    def read_only(self, read_only: bool) -> "ChildItemBuilder":
        self._child_item.read_only = read_only
        return self

    def min_value(self, min_value: str) -> "ChildItemBuilder":
        self._child_item.min_value = min_value
        return self

    def max_value(self, max_value: str) -> "ChildItemBuilder":
        self._child_item.max_value = max_value
        return self

    def build(self) -> "ChildItem":
        return self._child_item
