# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Coordinate(object):
    _types = {
        "longitude": float,
        "latitude": float,
        "accuracy": float,
    }

    def __init__(self, d=None):
        self.longitude: Optional[float] = None
        self.latitude: Optional[float] = None
        self.accuracy: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CoordinateBuilder":
        return CoordinateBuilder()


class CoordinateBuilder(object):
    def __init__(self) -> None:
        self._coordinate = Coordinate()

    def longitude(self, longitude: float) -> "CoordinateBuilder":
        self._coordinate.longitude = longitude
        return self

    def latitude(self, latitude: float) -> "CoordinateBuilder":
        self._coordinate.latitude = latitude
        return self

    def accuracy(self, accuracy: float) -> "CoordinateBuilder":
        self._coordinate.accuracy = accuracy
        return self

    def build(self) -> "Coordinate":
        return self._coordinate
