# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .group import Group


class CreateGroupRequestBody(object):
    _types = {
        "group": Group,
        "operator_id": str,
    }

    def __init__(self, d=None):
        self.group: Optional[Group] = None
        self.operator_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateGroupRequestBodyBuilder":
        return CreateGroupRequestBodyBuilder()


class CreateGroupRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_group_request_body = CreateGroupRequestBody()

    def group(self, group: Group) -> "CreateGroupRequestBodyBuilder":
        self._create_group_request_body.group = group
        return self

    def operator_id(self, operator_id: str) -> "CreateGroupRequestBodyBuilder":
        self._create_group_request_body.operator_id = operator_id
        return self

    def build(self) -> "CreateGroupRequestBody":
        return self._create_group_request_body
