# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_user_approval_request_body import CreateUserApprovalRequestBody


class CreateUserApprovalRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.request_body: Optional[CreateUserApprovalRequestBody] = None

    @staticmethod
    def builder() -> "CreateUserApprovalRequestBuilder":
        return CreateUserApprovalRequestBuilder()


class CreateUserApprovalRequestBuilder(object):

    def __init__(self) -> None:
        create_user_approval_request = CreateUserApprovalRequest()
        create_user_approval_request.http_method = HttpMethod.POST
        create_user_approval_request.uri = "/open-apis/attendance/v1/user_approvals"
        create_user_approval_request.token_types = {AccessTokenType.TENANT}
        self._create_user_approval_request: CreateUserApprovalRequest = create_user_approval_request

    def employee_type(self, employee_type: str) -> "CreateUserApprovalRequestBuilder":
        self._create_user_approval_request.employee_type = employee_type
        self._create_user_approval_request.add_query("employee_type", employee_type)
        return self

    def request_body(self, request_body: CreateUserApprovalRequestBody) -> "CreateUserApprovalRequestBuilder":
        self._create_user_approval_request.request_body = request_body
        self._create_user_approval_request.body = request_body
        return self

    def build(self) -> CreateUserApprovalRequest:
        return self._create_user_approval_request
