# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .user_task_remedy import UserTaskRemedy


class CreateUserTaskRemedyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.request_body: Optional[UserTaskRemedy] = None

    @staticmethod
    def builder() -> "CreateUserTaskRemedyRequestBuilder":
        return CreateUserTaskRemedyRequestBuilder()


class CreateUserTaskRemedyRequestBuilder(object):

    def __init__(self) -> None:
        create_user_task_remedy_request = CreateUserTaskRemedyRequest()
        create_user_task_remedy_request.http_method = HttpMethod.POST
        create_user_task_remedy_request.uri = "/open-apis/attendance/v1/user_task_remedys"
        create_user_task_remedy_request.token_types = {AccessTokenType.TENANT}
        self._create_user_task_remedy_request: CreateUserTaskRemedyRequest = create_user_task_remedy_request

    def employee_type(self, employee_type: str) -> "CreateUserTaskRemedyRequestBuilder":
        self._create_user_task_remedy_request.employee_type = employee_type
        self._create_user_task_remedy_request.add_query("employee_type", employee_type)
        return self

    def request_body(self, request_body: UserTaskRemedy) -> "CreateUserTaskRemedyRequestBuilder":
        self._create_user_task_remedy_request.request_body = request_body
        self._create_user_task_remedy_request.body = request_body
        return self

    def build(self) -> CreateUserTaskRemedyRequest:
        return self._create_user_task_remedy_request
