# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .child_field import ChildField


class Field(object):
    _types = {
        "code": str,
        "title": str,
        "child_fields": List[ChildField],
    }

    def __init__(self, d=None):
        self.code: Optional[str] = None
        self.title: Optional[str] = None
        self.child_fields: Optional[List[ChildField]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FieldBuilder":
        return FieldBuilder()


class FieldBuilder(object):
    def __init__(self) -> None:
        self._field = Field()

    def code(self, code: str) -> "FieldBuilder":
        self._field.code = code
        return self

    def title(self, title: str) -> "FieldBuilder":
        self._field.title = title
        return self

    def child_fields(self, child_fields: List[ChildField]) -> "FieldBuilder":
        self._field.child_fields = child_fields
        return self

    def build(self) -> "Field":
        return self._field
