# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class GetUserFlowResponseBody(object):
    _types = {
        "user_id": str,
        "creator_id": str,
        "location_name": str,
        "check_time": str,
        "comment": str,
        "record_id": str,
        "ssid": str,
        "bssid": str,
        "is_field": bool,
        "is_wifi": bool,
        "type": int,
        "photo_urls": List[str],
        "device_id": str,
        "check_result": str,
        "external_id": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.creator_id: Optional[str] = None
        self.location_name: Optional[str] = None
        self.check_time: Optional[str] = None
        self.comment: Optional[str] = None
        self.record_id: Optional[str] = None
        self.ssid: Optional[str] = None
        self.bssid: Optional[str] = None
        self.is_field: Optional[bool] = None
        self.is_wifi: Optional[bool] = None
        self.type: Optional[int] = None
        self.photo_urls: Optional[List[str]] = None
        self.device_id: Optional[str] = None
        self.check_result: Optional[str] = None
        self.external_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GetUserFlowResponseBodyBuilder":
        return GetUserFlowResponseBodyBuilder()


class GetUserFlowResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._get_user_flow_response_body = GetUserFlowResponseBody()

    def user_id(self, user_id: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.user_id = user_id
        return self

    def creator_id(self, creator_id: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.creator_id = creator_id
        return self

    def location_name(self, location_name: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.location_name = location_name
        return self

    def check_time(self, check_time: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.check_time = check_time
        return self

    def comment(self, comment: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.comment = comment
        return self

    def record_id(self, record_id: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.record_id = record_id
        return self

    def ssid(self, ssid: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.ssid = ssid
        return self

    def bssid(self, bssid: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.bssid = bssid
        return self

    def is_field(self, is_field: bool) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.is_field = is_field
        return self

    def is_wifi(self, is_wifi: bool) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.is_wifi = is_wifi
        return self

    def type(self, type: int) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.type = type
        return self

    def photo_urls(self, photo_urls: List[str]) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.photo_urls = photo_urls
        return self

    def device_id(self, device_id: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.device_id = device_id
        return self

    def check_result(self, check_result: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.check_result = check_result
        return self

    def external_id(self, external_id: str) -> "GetUserFlowResponseBodyBuilder":
        self._get_user_flow_response_body.external_id = external_id
        return self

    def build(self) -> "GetUserFlowResponseBody":
        return self._get_user_flow_response_body
