# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class GroupMeta(object):
    _types = {
        "group_id": str,
        "group_name": str,
    }

    def __init__(self, d=None):
        self.group_id: Optional[str] = None
        self.group_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GroupMetaBuilder":
        return GroupMetaBuilder()


class GroupMetaBuilder(object):
    def __init__(self) -> None:
        self._group_meta = GroupMeta()

    def group_id(self, group_id: str) -> "GroupMetaBuilder":
        self._group_meta.group_id = group_id
        return self

    def group_name(self, group_name: str) -> "GroupMetaBuilder":
        self._group_meta.group_name = group_name
        return self

    def build(self) -> "GroupMeta":
        return self._group_meta
