# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class LeaveNeedPunchCfg(object):
    _types = {
        "late_minutes_as_late": int,
        "late_minutes_as_lack": int,
        "early_minutes_as_early": int,
        "early_minutes_as_lack": int,
    }

    def __init__(self, d=None):
        self.late_minutes_as_late: Optional[int] = None
        self.late_minutes_as_lack: Optional[int] = None
        self.early_minutes_as_early: Optional[int] = None
        self.early_minutes_as_lack: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LeaveNeedPunchCfgBuilder":
        return LeaveNeedPunchCfgBuilder()


class LeaveNeedPunchCfgBuilder(object):
    def __init__(self) -> None:
        self._leave_need_punch_cfg = LeaveNeedPunchCfg()

    def late_minutes_as_late(self, late_minutes_as_late: int) -> "LeaveNeedPunchCfgBuilder":
        self._leave_need_punch_cfg.late_minutes_as_late = late_minutes_as_late
        return self

    def late_minutes_as_lack(self, late_minutes_as_lack: int) -> "LeaveNeedPunchCfgBuilder":
        self._leave_need_punch_cfg.late_minutes_as_lack = late_minutes_as_lack
        return self

    def early_minutes_as_early(self, early_minutes_as_early: int) -> "LeaveNeedPunchCfgBuilder":
        self._leave_need_punch_cfg.early_minutes_as_early = early_minutes_as_early
        return self

    def early_minutes_as_lack(self, early_minutes_as_lack: int) -> "LeaveNeedPunchCfgBuilder":
        self._leave_need_punch_cfg.early_minutes_as_lack = early_minutes_as_lack
        return self

    def build(self) -> "LeaveNeedPunchCfg":
        return self._leave_need_punch_cfg
