# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .group_meta import GroupMeta


class ListGroupResponseBody(object):
    _types = {
        "group_list": List[GroupMeta],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.group_list: Optional[List[GroupMeta]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListGroupResponseBodyBuilder":
        return ListGroupResponseBodyBuilder()


class ListGroupResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_group_response_body = ListGroupResponseBody()

    def group_list(self, group_list: List[GroupMeta]) -> "ListGroupResponseBodyBuilder":
        self._list_group_response_body.group_list = group_list
        return self

    def page_token(self, page_token: str) -> "ListGroupResponseBodyBuilder":
        self._list_group_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListGroupResponseBodyBuilder":
        self._list_group_response_body.has_more = has_more
        return self

    def build(self) -> "ListGroupResponseBody":
        return self._list_group_response_body
