# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .shift import Shift


class ListShiftResponseBody(object):
    _types = {
        "shift_list": List[Shift],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.shift_list: Optional[List[Shift]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListShiftResponseBodyBuilder":
        return ListShiftResponseBodyBuilder()


class ListShiftResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_shift_response_body = ListShiftResponseBody()

    def shift_list(self, shift_list: List[Shift]) -> "ListShiftResponseBodyBuilder":
        self._list_shift_response_body.shift_list = shift_list
        return self

    def page_token(self, page_token: str) -> "ListShiftResponseBodyBuilder":
        self._list_shift_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListShiftResponseBodyBuilder":
        self._list_shift_response_body.has_more = has_more
        return self

    def build(self) -> "ListShiftResponseBody":
        return self._list_shift_response_body
