# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Location(object):
    _types = {
        "location_id": str,
        "location_name": str,
        "location_type": int,
        "latitude": float,
        "longitude": float,
        "ssid": str,
        "bssid": str,
        "map_type": int,
        "address": str,
        "ip": str,
        "feature": str,
        "gps_range": int,
    }

    def __init__(self, d=None):
        self.location_id: Optional[str] = None
        self.location_name: Optional[str] = None
        self.location_type: Optional[int] = None
        self.latitude: Optional[float] = None
        self.longitude: Optional[float] = None
        self.ssid: Optional[str] = None
        self.bssid: Optional[str] = None
        self.map_type: Optional[int] = None
        self.address: Optional[str] = None
        self.ip: Optional[str] = None
        self.feature: Optional[str] = None
        self.gps_range: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LocationBuilder":
        return LocationBuilder()


class LocationBuilder(object):
    def __init__(self) -> None:
        self._location = Location()

    def location_id(self, location_id: str) -> "LocationBuilder":
        self._location.location_id = location_id
        return self

    def location_name(self, location_name: str) -> "LocationBuilder":
        self._location.location_name = location_name
        return self

    def location_type(self, location_type: int) -> "LocationBuilder":
        self._location.location_type = location_type
        return self

    def latitude(self, latitude: float) -> "LocationBuilder":
        self._location.latitude = latitude
        return self

    def longitude(self, longitude: float) -> "LocationBuilder":
        self._location.longitude = longitude
        return self

    def ssid(self, ssid: str) -> "LocationBuilder":
        self._location.ssid = ssid
        return self

    def bssid(self, bssid: str) -> "LocationBuilder":
        self._location.bssid = bssid
        return self

    def map_type(self, map_type: int) -> "LocationBuilder":
        self._location.map_type = map_type
        return self

    def address(self, address: str) -> "LocationBuilder":
        self._location.address = address
        return self

    def ip(self, ip: str) -> "LocationBuilder":
        self._location.ip = ip
        return self

    def feature(self, feature: str) -> "LocationBuilder":
        self._location.feature = feature
        return self

    def gps_range(self, gps_range: int) -> "LocationBuilder":
        self._location.gps_range = gps_range
        return self

    def build(self) -> "Location":
        return self._location
