# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .area import Area


class LocationInfo(object):
    _types = {
        "status": int,
        "geofences": List[Area],
    }

    def __init__(self, d=None):
        self.status: Optional[int] = None
        self.geofences: Optional[List[Area]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LocationInfoBuilder":
        return LocationInfoBuilder()


class LocationInfoBuilder(object):
    def __init__(self) -> None:
        self._location_info = LocationInfo()

    def status(self, status: int) -> "LocationInfoBuilder":
        self._location_info.status = status
        return self

    def geofences(self, geofences: List[Area]) -> "LocationInfoBuilder":
        self._location_info.geofences = geofences
        return self

    def build(self) -> "LocationInfo":
        return self._location_info
