# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class OvertimeTimeRange(object):
    _types = {
        "start_time": str,
        "end_time": str,
    }

    def __init__(self, d=None):
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OvertimeTimeRangeBuilder":
        return OvertimeTimeRangeBuilder()


class OvertimeTimeRangeBuilder(object):
    def __init__(self) -> None:
        self._overtime_time_range = OvertimeTimeRange()

    def start_time(self, start_time: str) -> "OvertimeTimeRangeBuilder":
        self._overtime_time_range.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "OvertimeTimeRangeBuilder":
        self._overtime_time_range.end_time = end_time
        return self

    def build(self) -> "OvertimeTimeRange":
        return self._overtime_time_range
