# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class QueryShiftRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.shift_name: Optional[str] = None

    @staticmethod
    def builder() -> "QueryShiftRequestBuilder":
        return QueryShiftRequestBuilder()


class QueryShiftRequestBuilder(object):

    def __init__(self) -> None:
        query_shift_request = QueryShiftRequest()
        query_shift_request.http_method = HttpMethod.POST
        query_shift_request.uri = "/open-apis/attendance/v1/shifts/query"
        query_shift_request.token_types = {AccessTokenType.TENANT}
        self._query_shift_request: QueryShiftRequest = query_shift_request

    def shift_name(self, shift_name: str) -> "QueryShiftRequestBuilder":
        self._query_shift_request.shift_name = shift_name
        self._query_shift_request.add_query("shift_name", shift_name)
        return self

    def build(self) -> QueryShiftRequest:
        return self._query_shift_request
