# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_user_approval_request_body import QueryUserApprovalRequestBody


class QueryUserApprovalRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.request_body: Optional[QueryUserApprovalRequestBody] = None

    @staticmethod
    def builder() -> "QueryUserApprovalRequestBuilder":
        return QueryUserApprovalRequestBuilder()


class QueryUserApprovalRequestBuilder(object):

    def __init__(self) -> None:
        query_user_approval_request = QueryUserApprovalRequest()
        query_user_approval_request.http_method = HttpMethod.POST
        query_user_approval_request.uri = "/open-apis/attendance/v1/user_approvals/query"
        query_user_approval_request.token_types = {AccessTokenType.TENANT}
        self._query_user_approval_request: QueryUserApprovalRequest = query_user_approval_request

    def employee_type(self, employee_type: str) -> "QueryUserApprovalRequestBuilder":
        self._query_user_approval_request.employee_type = employee_type
        self._query_user_approval_request.add_query("employee_type", employee_type)
        return self

    def request_body(self, request_body: QueryUserApprovalRequestBody) -> "QueryUserApprovalRequestBuilder":
        self._query_user_approval_request.request_body = request_body
        self._query_user_approval_request.body = request_body
        return self

    def build(self) -> QueryUserApprovalRequest:
        return self._query_user_approval_request
