# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class QueryUserApprovalRequestBody(object):
    _types = {
        "user_ids": List[str],
        "check_date_from": int,
        "check_date_to": int,
        "check_date_type": str,
        "status": int,
        "check_time_from": str,
        "check_time_to": str,
    }

    def __init__(self, d=None):
        self.user_ids: Optional[List[str]] = None
        self.check_date_from: Optional[int] = None
        self.check_date_to: Optional[int] = None
        self.check_date_type: Optional[str] = None
        self.status: Optional[int] = None
        self.check_time_from: Optional[str] = None
        self.check_time_to: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "QueryUserApprovalRequestBodyBuilder":
        return QueryUserApprovalRequestBodyBuilder()


class QueryUserApprovalRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._query_user_approval_request_body = QueryUserApprovalRequestBody()

    def user_ids(self, user_ids: List[str]) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.user_ids = user_ids
        return self

    def check_date_from(self, check_date_from: int) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.check_date_from = check_date_from
        return self

    def check_date_to(self, check_date_to: int) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.check_date_to = check_date_to
        return self

    def check_date_type(self, check_date_type: str) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.check_date_type = check_date_type
        return self

    def status(self, status: int) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.status = status
        return self

    def check_time_from(self, check_time_from: str) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.check_time_from = check_time_from
        return self

    def check_time_to(self, check_time_to: str) -> "QueryUserApprovalRequestBodyBuilder":
        self._query_user_approval_request_body.check_time_to = check_time_to
        return self

    def build(self) -> "QueryUserApprovalRequestBody":
        return self._query_user_approval_request_body
