# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class QueryUserFlowRequestBody(object):
    _types = {
        "user_ids": List[str],
        "check_time_from": str,
        "check_time_to": str,
    }

    def __init__(self, d=None):
        self.user_ids: Optional[List[str]] = None
        self.check_time_from: Optional[str] = None
        self.check_time_to: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "QueryUserFlowRequestBodyBuilder":
        return QueryUserFlowRequestBodyBuilder()


class QueryUserFlowRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._query_user_flow_request_body = QueryUserFlowRequestBody()

    def user_ids(self, user_ids: List[str]) -> "QueryUserFlowRequestBodyBuilder":
        self._query_user_flow_request_body.user_ids = user_ids
        return self

    def check_time_from(self, check_time_from: str) -> "QueryUserFlowRequestBodyBuilder":
        self._query_user_flow_request_body.check_time_from = check_time_from
        return self

    def check_time_to(self, check_time_to: str) -> "QueryUserFlowRequestBodyBuilder":
        self._query_user_flow_request_body.check_time_to = check_time_to
        return self

    def build(self) -> "QueryUserFlowRequestBody":
        return self._query_user_flow_request_body
