# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_user_setting_request_body import QueryUserSettingRequestBody


class QueryUserSettingRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.request_body: Optional[QueryUserSettingRequestBody] = None

    @staticmethod
    def builder() -> "QueryUserSettingRequestBuilder":
        return QueryUserSettingRequestBuilder()


class QueryUserSettingRequestBuilder(object):

    def __init__(self) -> None:
        query_user_setting_request = QueryUserSettingRequest()
        query_user_setting_request.http_method = HttpMethod.GET
        query_user_setting_request.uri = "/open-apis/attendance/v1/user_settings/query"
        query_user_setting_request.token_types = {AccessTokenType.TENANT}
        self._query_user_setting_request: QueryUserSettingRequest = query_user_setting_request

    def employee_type(self, employee_type: str) -> "QueryUserSettingRequestBuilder":
        self._query_user_setting_request.employee_type = employee_type
        self._query_user_setting_request.add_query("employee_type", employee_type)
        return self

    def request_body(self, request_body: QueryUserSettingRequestBody) -> "QueryUserSettingRequestBuilder":
        self._query_user_setting_request.request_body = request_body
        self._query_user_setting_request.body = request_body
        return self

    def build(self) -> QueryUserSettingRequest:
        return self._query_user_setting_request
