# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_user_stats_view_request_body import QueryUserStatsViewRequestBody


class QueryUserStatsViewRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.request_body: Optional[QueryUserStatsViewRequestBody] = None

    @staticmethod
    def builder() -> "QueryUserStatsViewRequestBuilder":
        return QueryUserStatsViewRequestBuilder()


class QueryUserStatsViewRequestBuilder(object):

    def __init__(self) -> None:
        query_user_stats_view_request = QueryUserStatsViewRequest()
        query_user_stats_view_request.http_method = HttpMethod.POST
        query_user_stats_view_request.uri = "/open-apis/attendance/v1/user_stats_views/query"
        query_user_stats_view_request.token_types = {AccessTokenType.TENANT}
        self._query_user_stats_view_request: QueryUserStatsViewRequest = query_user_stats_view_request

    def employee_type(self, employee_type: str) -> "QueryUserStatsViewRequestBuilder":
        self._query_user_stats_view_request.employee_type = employee_type
        self._query_user_stats_view_request.add_query("employee_type", employee_type)
        return self

    def request_body(self, request_body: QueryUserStatsViewRequestBody) -> "QueryUserStatsViewRequestBuilder":
        self._query_user_stats_view_request.request_body = request_body
        self._query_user_stats_view_request.body = request_body
        return self

    def build(self) -> QueryUserStatsViewRequest:
        return self._query_user_stats_view_request
