# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class StatusChange(object):
    _types = {
        "index": int,
        "before_status": str,
        "current_status": str,
        "before_supplement": str,
        "current_supplement": str,
        "work_type": str,
    }

    def __init__(self, d=None):
        self.index: Optional[int] = None
        self.before_status: Optional[str] = None
        self.current_status: Optional[str] = None
        self.before_supplement: Optional[str] = None
        self.current_supplement: Optional[str] = None
        self.work_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "StatusChangeBuilder":
        return StatusChangeBuilder()


class StatusChangeBuilder(object):
    def __init__(self) -> None:
        self._status_change = StatusChange()

    def index(self, index: int) -> "StatusChangeBuilder":
        self._status_change.index = index
        return self

    def before_status(self, before_status: str) -> "StatusChangeBuilder":
        self._status_change.before_status = before_status
        return self

    def current_status(self, current_status: str) -> "StatusChangeBuilder":
        self._status_change.current_status = current_status
        return self

    def before_supplement(self, before_supplement: str) -> "StatusChangeBuilder":
        self._status_change.before_supplement = before_supplement
        return self

    def current_supplement(self, current_supplement: str) -> "StatusChangeBuilder":
        self._status_change.current_supplement = current_supplement
        return self

    def work_type(self, work_type: str) -> "StatusChangeBuilder":
        self._status_change.work_type = work_type
        return self

    def build(self) -> "StatusChange":
        return self._status_change
