# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_user_stats_view_request_body import UpdateUserStatsViewRequestBody


class UpdateUserStatsViewRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.employee_type: Optional[str] = None
        self.user_stats_view_id: Optional[str] = None
        self.request_body: Optional[UpdateUserStatsViewRequestBody] = None

    @staticmethod
    def builder() -> "UpdateUserStatsViewRequestBuilder":
        return UpdateUserStatsViewRequestBuilder()


class UpdateUserStatsViewRequestBuilder(object):

    def __init__(self) -> None:
        update_user_stats_view_request = UpdateUserStatsViewRequest()
        update_user_stats_view_request.http_method = HttpMethod.PUT
        update_user_stats_view_request.uri = "/open-apis/attendance/v1/user_stats_views/:user_stats_view_id"
        update_user_stats_view_request.token_types = {AccessTokenType.TENANT}
        self._update_user_stats_view_request: UpdateUserStatsViewRequest = update_user_stats_view_request

    def employee_type(self, employee_type: str) -> "UpdateUserStatsViewRequestBuilder":
        self._update_user_stats_view_request.employee_type = employee_type
        self._update_user_stats_view_request.add_query("employee_type", employee_type)
        return self

    def user_stats_view_id(self, user_stats_view_id: str) -> "UpdateUserStatsViewRequestBuilder":
        self._update_user_stats_view_request.user_stats_view_id = user_stats_view_id
        self._update_user_stats_view_request.paths["user_stats_view_id"] = str(user_stats_view_id)
        return self

    def request_body(self, request_body: UpdateUserStatsViewRequestBody) -> "UpdateUserStatsViewRequestBuilder":
        self._update_user_stats_view_request.request_body = request_body
        self._update_user_stats_view_request.body = request_body
        return self

    def build(self) -> UpdateUserStatsViewRequest:
        return self._update_user_stats_view_request
