# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserDailyShift(object):
    _types = {
        "group_id": str,
        "shift_id": str,
        "month": int,
        "user_id": str,
        "day_no": int,
    }

    def __init__(self, d=None):
        self.group_id: Optional[str] = None
        self.shift_id: Optional[str] = None
        self.month: Optional[int] = None
        self.user_id: Optional[str] = None
        self.day_no: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserDailyShiftBuilder":
        return UserDailyShiftBuilder()


class UserDailyShiftBuilder(object):
    def __init__(self) -> None:
        self._user_daily_shift = UserDailyShift()

    def group_id(self, group_id: str) -> "UserDailyShiftBuilder":
        self._user_daily_shift.group_id = group_id
        return self

    def shift_id(self, shift_id: str) -> "UserDailyShiftBuilder":
        self._user_daily_shift.shift_id = shift_id
        return self

    def month(self, month: int) -> "UserDailyShiftBuilder":
        self._user_daily_shift.month = month
        return self

    def user_id(self, user_id: str) -> "UserDailyShiftBuilder":
        self._user_daily_shift.user_id = user_id
        return self

    def day_no(self, day_no: int) -> "UserDailyShiftBuilder":
        self._user_daily_shift.day_no = day_no
        return self

    def build(self) -> "UserDailyShift":
        return self._user_daily_shift
