# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class UserFlow(object):
    _types = {
        "user_id": str,
        "creator_id": str,
        "location_name": str,
        "check_time": str,
        "comment": str,
        "record_id": str,
        "ssid": str,
        "bssid": str,
        "is_field": bool,
        "is_wifi": bool,
        "type": int,
        "photo_urls": List[str],
        "device_id": str,
        "check_result": str,
        "external_id": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.creator_id: Optional[str] = None
        self.location_name: Optional[str] = None
        self.check_time: Optional[str] = None
        self.comment: Optional[str] = None
        self.record_id: Optional[str] = None
        self.ssid: Optional[str] = None
        self.bssid: Optional[str] = None
        self.is_field: Optional[bool] = None
        self.is_wifi: Optional[bool] = None
        self.type: Optional[int] = None
        self.photo_urls: Optional[List[str]] = None
        self.device_id: Optional[str] = None
        self.check_result: Optional[str] = None
        self.external_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserFlowBuilder":
        return UserFlowBuilder()


class UserFlowBuilder(object):
    def __init__(self) -> None:
        self._user_flow = UserFlow()

    def user_id(self, user_id: str) -> "UserFlowBuilder":
        self._user_flow.user_id = user_id
        return self

    def creator_id(self, creator_id: str) -> "UserFlowBuilder":
        self._user_flow.creator_id = creator_id
        return self

    def location_name(self, location_name: str) -> "UserFlowBuilder":
        self._user_flow.location_name = location_name
        return self

    def check_time(self, check_time: str) -> "UserFlowBuilder":
        self._user_flow.check_time = check_time
        return self

    def comment(self, comment: str) -> "UserFlowBuilder":
        self._user_flow.comment = comment
        return self

    def record_id(self, record_id: str) -> "UserFlowBuilder":
        self._user_flow.record_id = record_id
        return self

    def ssid(self, ssid: str) -> "UserFlowBuilder":
        self._user_flow.ssid = ssid
        return self

    def bssid(self, bssid: str) -> "UserFlowBuilder":
        self._user_flow.bssid = bssid
        return self

    def is_field(self, is_field: bool) -> "UserFlowBuilder":
        self._user_flow.is_field = is_field
        return self

    def is_wifi(self, is_wifi: bool) -> "UserFlowBuilder":
        self._user_flow.is_wifi = is_wifi
        return self

    def type(self, type: int) -> "UserFlowBuilder":
        self._user_flow.type = type
        return self

    def photo_urls(self, photo_urls: List[str]) -> "UserFlowBuilder":
        self._user_flow.photo_urls = photo_urls
        return self

    def device_id(self, device_id: str) -> "UserFlowBuilder":
        self._user_flow.device_id = device_id
        return self

    def check_result(self, check_result: str) -> "UserFlowBuilder":
        self._user_flow.check_result = check_result
        return self

    def external_id(self, external_id: str) -> "UserFlowBuilder":
        self._user_flow.external_id = external_id
        return self

    def build(self) -> "UserFlow":
        return self._user_flow
