# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserTrip(object):
    _types = {
        "approval_id": str,
        "start_time": str,
        "end_time": str,
        "reason": str,
        "approve_pass_time": str,
        "approve_apply_time": str,
    }

    def __init__(self, d=None):
        self.approval_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.reason: Optional[str] = None
        self.approve_pass_time: Optional[str] = None
        self.approve_apply_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserTripBuilder":
        return UserTripBuilder()


class UserTripBuilder(object):
    def __init__(self) -> None:
        self._user_trip = UserTrip()

    def approval_id(self, approval_id: str) -> "UserTripBuilder":
        self._user_trip.approval_id = approval_id
        return self

    def start_time(self, start_time: str) -> "UserTripBuilder":
        self._user_trip.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "UserTripBuilder":
        self._user_trip.end_time = end_time
        return self

    def reason(self, reason: str) -> "UserTripBuilder":
        self._user_trip.reason = reason
        return self

    def approve_pass_time(self, approve_pass_time: str) -> "UserTripBuilder":
        self._user_trip.approve_pass_time = approve_pass_time
        return self

    def approve_apply_time(self, approve_apply_time: str) -> "UserTripBuilder":
        self._user_trip.approve_apply_time = approve_apply_time
        return self

    def build(self) -> "UserTrip":
        return self._user_trip
