# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class WifiInfoEvent(object):
    _types = {
        "ssid": str,
        "bssid": str,
        "lastssid": str,
        "lastbssid": str,
    }

    def __init__(self, d=None):
        self.ssid: Optional[str] = None
        self.bssid: Optional[str] = None
        self.lastssid: Optional[str] = None
        self.lastbssid: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WifiInfoEventBuilder":
        return WifiInfoEventBuilder()


class WifiInfoEventBuilder(object):
    def __init__(self) -> None:
        self._wifi_info_event = WifiInfoEvent()

    def ssid(self, ssid: str) -> "WifiInfoEventBuilder":
        self._wifi_info_event.ssid = ssid
        return self

    def bssid(self, bssid: str) -> "WifiInfoEventBuilder":
        self._wifi_info_event.bssid = bssid
        return self

    def lastssid(self, lastssid: str) -> "WifiInfoEventBuilder":
        self._wifi_info_event.lastssid = lastssid
        return self

    def lastbssid(self, lastbssid: str) -> "WifiInfoEventBuilder":
        self._wifi_info_event.lastbssid = lastbssid
        return self

    def build(self) -> "WifiInfoEvent":
        return self._wifi_info_event
