# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_group_request import CreateGroupRequest
from ..model.create_group_response import CreateGroupResponse
from ..model.delete_group_request import DeleteGroupRequest
from ..model.delete_group_response import DeleteGroupResponse
from ..model.get_group_request import GetGroupRequest
from ..model.get_group_response import GetGroupResponse
from ..model.list_group_request import ListGroupRequest
from ..model.list_group_response import ListGroupResponse
from ..model.search_group_request import SearchGroupRequest
from ..model.search_group_response import SearchGroupResponse


class Group(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateGroupRequest, option: Optional[RequestOption] = None) -> CreateGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateGroupResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateGroupRequest, option: Optional[RequestOption] = None) -> CreateGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateGroupResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteGroupRequest, option: Optional[RequestOption] = None) -> DeleteGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteGroupResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteGroupRequest, option: Optional[RequestOption] = None) -> DeleteGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteGroupResponse)
        response.raw = resp

        return response

    def get(self, request: GetGroupRequest, option: Optional[RequestOption] = None) -> GetGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), GetGroupResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetGroupRequest, option: Optional[RequestOption] = None) -> GetGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), GetGroupResponse)
        response.raw = resp

        return response

    def list(self, request: ListGroupRequest, option: Optional[RequestOption] = None) -> ListGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), ListGroupResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListGroupRequest, option: Optional[RequestOption] = None) -> ListGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), ListGroupResponse)
        response.raw = resp

        return response

    def search(self, request: SearchGroupRequest, option: Optional[RequestOption] = None) -> SearchGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchGroupResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchGroupRequest, option: Optional[RequestOption] = None) -> SearchGroupResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchGroupResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchGroupResponse)
        response.raw = resp

        return response
