# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_user_approval_request import CreateUserApprovalRequest
from ..model.create_user_approval_response import CreateUserApprovalResponse
from ..model.query_user_approval_request import QueryUserApprovalRequest
from ..model.query_user_approval_response import QueryUserApprovalResponse


class UserApproval(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateUserApprovalRequest,
               option: Optional[RequestOption] = None) -> CreateUserApprovalResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateUserApprovalResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserApprovalResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateUserApprovalRequest,
                      option: Optional[RequestOption] = None) -> CreateUserApprovalResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateUserApprovalResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserApprovalResponse)
        response.raw = resp

        return response

    def query(self, request: QueryUserApprovalRequest,
              option: Optional[RequestOption] = None) -> QueryUserApprovalResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryUserApprovalResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserApprovalResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryUserApprovalRequest,
                     option: Optional[RequestOption] = None) -> QueryUserApprovalResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryUserApprovalResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserApprovalResponse)
        response.raw = resp

        return response
