# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_create_user_daily_shift_request import BatchCreateUserDailyShiftRequest
from ..model.batch_create_user_daily_shift_response import BatchCreateUserDailyShiftResponse
from ..model.query_user_daily_shift_request import QueryUserDailyShiftRequest
from ..model.query_user_daily_shift_response import QueryUserDailyShiftResponse


class UserDailyShift(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_create(self, request: BatchCreateUserDailyShiftRequest,
                     option: Optional[RequestOption] = None) -> BatchCreateUserDailyShiftResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCreateUserDailyShiftResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchCreateUserDailyShiftResponse)
        response.raw = resp

        return response

    async def abatch_create(self, request: BatchCreateUserDailyShiftRequest,
                            option: Optional[RequestOption] = None) -> BatchCreateUserDailyShiftResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCreateUserDailyShiftResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     BatchCreateUserDailyShiftResponse)
        response.raw = resp

        return response

    def query(self, request: QueryUserDailyShiftRequest,
              option: Optional[RequestOption] = None) -> QueryUserDailyShiftResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryUserDailyShiftResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserDailyShiftResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryUserDailyShiftRequest,
                     option: Optional[RequestOption] = None) -> QueryUserDailyShiftResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryUserDailyShiftResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserDailyShiftResponse)
        response.raw = resp

        return response
