# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_user_task_remedy_request import CreateUserTaskRemedyRequest
from ..model.create_user_task_remedy_response import CreateUserTaskRemedyResponse
from ..model.query_user_allowed_remedys_user_task_remedy_request import QueryUserAllowedRemedysUserTaskRemedyRequest
from ..model.query_user_allowed_remedys_user_task_remedy_response import QueryUserAllowedRemedysUserTaskRemedyResponse
from ..model.query_user_task_remedy_request import QueryUserTaskRemedyRequest
from ..model.query_user_task_remedy_response import QueryUserTaskRemedyResponse


class UserTaskRemedy(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateUserTaskRemedyRequest,
               option: Optional[RequestOption] = None) -> CreateUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserTaskRemedyResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateUserTaskRemedyRequest,
                      option: Optional[RequestOption] = None) -> CreateUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateUserTaskRemedyResponse)
        response.raw = resp

        return response

    def query(self, request: QueryUserTaskRemedyRequest,
              option: Optional[RequestOption] = None) -> QueryUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserTaskRemedyResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryUserTaskRemedyRequest,
                     option: Optional[RequestOption] = None) -> QueryUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryUserTaskRemedyResponse)
        response.raw = resp

        return response

    def query_user_allowed_remedys(self, request: QueryUserAllowedRemedysUserTaskRemedyRequest, option: Optional[
        RequestOption] = None) -> QueryUserAllowedRemedysUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryUserAllowedRemedysUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                 QueryUserAllowedRemedysUserTaskRemedyResponse)
        response.raw = resp

        return response

    async def aquery_user_allowed_remedys(self, request: QueryUserAllowedRemedysUserTaskRemedyRequest, option: Optional[
        RequestOption] = None) -> QueryUserAllowedRemedysUserTaskRemedyResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryUserAllowedRemedysUserTaskRemedyResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                                 QueryUserAllowedRemedysUserTaskRemedyResponse)
        response.raw = resp

        return response
