# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod
from lark_oapi.core.model import BaseRequest
from .create_app_access_token_request_body import CreateAppAccessTokenRequestBody


class CreateAppAccessTokenRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateAppAccessTokenRequestBody] = None

    @staticmethod
    def builder() -> "CreateAppAccessTokenRequestBuilder":
        return CreateAppAccessTokenRequestBuilder()


class CreateAppAccessTokenRequestBuilder(object):

    def __init__(self) -> None:
        create_app_access_token_request = CreateAppAccessTokenRequest()
        create_app_access_token_request.http_method = HttpMethod.POST
        create_app_access_token_request.uri = "/open-apis/auth/v3/app_access_token"
        create_app_access_token_request.token_types = {}
        self._create_app_access_token_request: CreateAppAccessTokenRequest = create_app_access_token_request

    def request_body(self, request_body: CreateAppAccessTokenRequestBody) -> "CreateAppAccessTokenRequestBuilder":
        self._create_app_access_token_request.request_body = request_body
        self._create_app_access_token_request.body = request_body
        return self

    def build(self) -> CreateAppAccessTokenRequest:
        return self._create_app_access_token_request
