# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CreateAppAccessTokenRequestBody(object):
    _types = {
        "app_id": str,
        "app_secret": str,
        "app_ticket": str,
    }

    def __init__(self, d=None):
        self.app_id: Optional[str] = None
        self.app_secret: Optional[str] = None
        self.app_ticket: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateAppAccessTokenRequestBodyBuilder":
        return CreateAppAccessTokenRequestBodyBuilder()


class CreateAppAccessTokenRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_app_access_token_request_body = CreateAppAccessTokenRequestBody()

    def app_id(self, app_id: str) -> "CreateAppAccessTokenRequestBodyBuilder":
        self._create_app_access_token_request_body.app_id = app_id
        return self

    def app_secret(self, app_secret: str) -> "CreateAppAccessTokenRequestBodyBuilder":
        self._create_app_access_token_request_body.app_secret = app_secret
        return self

    def app_ticket(self, app_ticket: str) -> "CreateAppAccessTokenRequestBodyBuilder":
        self._create_app_access_token_request_body.app_ticket = app_ticket
        return self

    def build(self) -> "CreateAppAccessTokenRequestBody":
        return self._create_app_access_token_request_body
