# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod
from lark_oapi.core.model import BaseRequest
from .internal_tenant_access_token_request_body import InternalTenantAccessTokenRequestBody


class InternalTenantAccessTokenRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[InternalTenantAccessTokenRequestBody] = None

    @staticmethod
    def builder() -> "InternalTenantAccessTokenRequestBuilder":
        return InternalTenantAccessTokenRequestBuilder()


class InternalTenantAccessTokenRequestBuilder(object):

    def __init__(self) -> None:
        internal_tenant_access_token_request = InternalTenantAccessTokenRequest()
        internal_tenant_access_token_request.http_method = HttpMethod.POST
        internal_tenant_access_token_request.uri = "/open-apis/auth/v3/tenant_access_token/internal"
        internal_tenant_access_token_request.token_types = {}
        self._internal_tenant_access_token_request: InternalTenantAccessTokenRequest = internal_tenant_access_token_request

    def request_body(self,
                     request_body: InternalTenantAccessTokenRequestBody) -> "InternalTenantAccessTokenRequestBuilder":
        self._internal_tenant_access_token_request.request_body = request_body
        self._internal_tenant_access_token_request.body = request_body
        return self

    def build(self) -> InternalTenantAccessTokenRequest:
        return self._internal_tenant_access_token_request
