# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CreateAccessTokenResponseBody(object):
    _types = {
        "access_token": str,
        "token_type": str,
        "expires_in": int,
        "name": str,
        "en_name": str,
        "avatar_url": str,
        "avatar_thumb": str,
        "avatar_middle": str,
        "avatar_big": str,
        "open_id": str,
        "union_id": str,
        "email": str,
        "enterprise_email": str,
        "user_id": str,
        "mobile": str,
        "tenant_key": str,
        "refresh_expires_in": int,
        "refresh_token": str,
        "sid": str,
    }

    def __init__(self, d=None):
        self.access_token: Optional[str] = None
        self.token_type: Optional[str] = None
        self.expires_in: Optional[int] = None
        self.name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.avatar_url: Optional[str] = None
        self.avatar_thumb: Optional[str] = None
        self.avatar_middle: Optional[str] = None
        self.avatar_big: Optional[str] = None
        self.open_id: Optional[str] = None
        self.union_id: Optional[str] = None
        self.email: Optional[str] = None
        self.enterprise_email: Optional[str] = None
        self.user_id: Optional[str] = None
        self.mobile: Optional[str] = None
        self.tenant_key: Optional[str] = None
        self.refresh_expires_in: Optional[int] = None
        self.refresh_token: Optional[str] = None
        self.sid: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateAccessTokenResponseBodyBuilder":
        return CreateAccessTokenResponseBodyBuilder()


class CreateAccessTokenResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._create_access_token_response_body = CreateAccessTokenResponseBody()

    def access_token(self, access_token: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.access_token = access_token
        return self

    def token_type(self, token_type: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.token_type = token_type
        return self

    def expires_in(self, expires_in: int) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.expires_in = expires_in
        return self

    def name(self, name: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.name = name
        return self

    def en_name(self, en_name: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.en_name = en_name
        return self

    def avatar_url(self, avatar_url: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.avatar_url = avatar_url
        return self

    def avatar_thumb(self, avatar_thumb: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.avatar_thumb = avatar_thumb
        return self

    def avatar_middle(self, avatar_middle: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.avatar_middle = avatar_middle
        return self

    def avatar_big(self, avatar_big: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.avatar_big = avatar_big
        return self

    def open_id(self, open_id: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.open_id = open_id
        return self

    def union_id(self, union_id: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.union_id = union_id
        return self

    def email(self, email: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.email = email
        return self

    def enterprise_email(self, enterprise_email: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.enterprise_email = enterprise_email
        return self

    def user_id(self, user_id: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.user_id = user_id
        return self

    def mobile(self, mobile: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.mobile = mobile
        return self

    def tenant_key(self, tenant_key: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.tenant_key = tenant_key
        return self

    def refresh_expires_in(self, refresh_expires_in: int) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.refresh_expires_in = refresh_expires_in
        return self

    def refresh_token(self, refresh_token: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.refresh_token = refresh_token
        return self

    def sid(self, sid: str) -> "CreateAccessTokenResponseBodyBuilder":
        self._create_access_token_response_body.sid = sid
        return self

    def build(self) -> "CreateAccessTokenResponseBody":
        return self._create_access_token_response_body
