# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_oidc_refresh_access_token_request_body import CreateOidcRefreshAccessTokenRequestBody


class CreateOidcRefreshAccessTokenRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateOidcRefreshAccessTokenRequestBody] = None

    @staticmethod
    def builder() -> "CreateOidcRefreshAccessTokenRequestBuilder":
        return CreateOidcRefreshAccessTokenRequestBuilder()


class CreateOidcRefreshAccessTokenRequestBuilder(object):

    def __init__(self) -> None:
        create_oidc_refresh_access_token_request = CreateOidcRefreshAccessTokenRequest()
        create_oidc_refresh_access_token_request.http_method = HttpMethod.POST
        create_oidc_refresh_access_token_request.uri = "/open-apis/authen/v1/oidc/refresh_access_token"
        create_oidc_refresh_access_token_request.token_types = {AccessTokenType.APP}
        self._create_oidc_refresh_access_token_request: CreateOidcRefreshAccessTokenRequest = create_oidc_refresh_access_token_request

    def request_body(self,
                     request_body: CreateOidcRefreshAccessTokenRequestBody) -> "CreateOidcRefreshAccessTokenRequestBuilder":
        self._create_oidc_refresh_access_token_request.request_body = request_body
        self._create_oidc_refresh_access_token_request.body = request_body
        return self

    def build(self) -> CreateOidcRefreshAccessTokenRequest:
        return self._create_oidc_refresh_access_token_request
