# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_refresh_access_token_request_body import CreateRefreshAccessTokenRequestBody


class CreateRefreshAccessTokenRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateRefreshAccessTokenRequestBody] = None

    @staticmethod
    def builder() -> "CreateRefreshAccessTokenRequestBuilder":
        return CreateRefreshAccessTokenRequestBuilder()


class CreateRefreshAccessTokenRequestBuilder(object):

    def __init__(self) -> None:
        create_refresh_access_token_request = CreateRefreshAccessTokenRequest()
        create_refresh_access_token_request.http_method = HttpMethod.POST
        create_refresh_access_token_request.uri = "/open-apis/authen/v1/refresh_access_token"
        create_refresh_access_token_request.token_types = {AccessTokenType.APP}
        self._create_refresh_access_token_request: CreateRefreshAccessTokenRequest = create_refresh_access_token_request

    def request_body(self,
                     request_body: CreateRefreshAccessTokenRequestBody) -> "CreateRefreshAccessTokenRequestBuilder":
        self._create_refresh_access_token_request.request_body = request_body
        self._create_refresh_access_token_request.body = request_body
        return self

    def build(self) -> CreateRefreshAccessTokenRequest:
        return self._create_refresh_access_token_request
