# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CreateRefreshAccessTokenRequestBody(object):
    _types = {
        "grant_type": str,
        "refresh_token": str,
    }

    def __init__(self, d=None):
        self.grant_type: Optional[str] = None
        self.refresh_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateRefreshAccessTokenRequestBodyBuilder":
        return CreateRefreshAccessTokenRequestBodyBuilder()


class CreateRefreshAccessTokenRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_refresh_access_token_request_body = CreateRefreshAccessTokenRequestBody()

    def grant_type(self, grant_type: str) -> "CreateRefreshAccessTokenRequestBodyBuilder":
        self._create_refresh_access_token_request_body.grant_type = grant_type
        return self

    def refresh_token(self, refresh_token: str) -> "CreateRefreshAccessTokenRequestBodyBuilder":
        self._create_refresh_access_token_request_body.refresh_token = refresh_token
        return self

    def build(self) -> "CreateRefreshAccessTokenRequestBody":
        return self._create_refresh_access_token_request_body
