# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod
from lark_oapi.core.model import BaseRequest


class GetAuthorizeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_id: Optional[str] = None
        self.redirect_uri: Optional[str] = None
        self.scope: Optional[str] = None
        self.state: Optional[str] = None

    @staticmethod
    def builder() -> "GetAuthorizeRequestBuilder":
        return GetAuthorizeRequestBuilder()


class GetAuthorizeRequestBuilder(object):

    def __init__(self) -> None:
        get_authorize_request = GetAuthorizeRequest()
        get_authorize_request.http_method = HttpMethod.GET
        get_authorize_request.uri = "/open-apis/authen/v1/authorize"
        get_authorize_request.token_types = {}
        self._get_authorize_request: GetAuthorizeRequest = get_authorize_request

    def app_id(self, app_id: str) -> "GetAuthorizeRequestBuilder":
        self._get_authorize_request.app_id = app_id
        self._get_authorize_request.add_query("app_id", app_id)
        return self

    def redirect_uri(self, redirect_uri: str) -> "GetAuthorizeRequestBuilder":
        self._get_authorize_request.redirect_uri = redirect_uri
        self._get_authorize_request.add_query("redirect_uri", redirect_uri)
        return self

    def scope(self, scope: str) -> "GetAuthorizeRequestBuilder":
        self._get_authorize_request.scope = scope
        self._get_authorize_request.add_query("scope", scope)
        return self

    def state(self, state: str) -> "GetAuthorizeRequestBuilder":
        self._get_authorize_request.state = state
        self._get_authorize_request.add_query("state", state)
        return self

    def build(self) -> GetAuthorizeRequest:
        return self._get_authorize_request
