# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .entity import Entity


class CreateDraftRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[Entity] = None

    @staticmethod
    def builder() -> "CreateDraftRequestBuilder":
        return CreateDraftRequestBuilder()


class CreateDraftRequestBuilder(object):

    def __init__(self) -> None:
        create_draft_request = CreateDraftRequest()
        create_draft_request.http_method = HttpMethod.POST
        create_draft_request.uri = "/open-apis/baike/v1/drafts"
        create_draft_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._create_draft_request: CreateDraftRequest = create_draft_request

    def user_id_type(self, user_id_type: str) -> "CreateDraftRequestBuilder":
        self._create_draft_request.user_id_type = user_id_type
        self._create_draft_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: Entity) -> "CreateDraftRequestBuilder":
        self._create_draft_request.request_body = request_body
        self._create_draft_request.body = request_body
        return self

    def build(self) -> CreateDraftRequest:
        return self._create_draft_request
