# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .match_entity_request_body import MatchEntityRequestBody


class MatchEntityRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[MatchEntityRequestBody] = None

    @staticmethod
    def builder() -> "MatchEntityRequestBuilder":
        return MatchEntityRequestBuilder()


class MatchEntityRequestBuilder(object):

    def __init__(self) -> None:
        match_entity_request = MatchEntityRequest()
        match_entity_request.http_method = HttpMethod.POST
        match_entity_request.uri = "/open-apis/baike/v1/entities/match"
        match_entity_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._match_entity_request: MatchEntityRequest = match_entity_request

    def request_body(self, request_body: MatchEntityRequestBody) -> "MatchEntityRequestBuilder":
        self._match_entity_request.request_body = request_body
        self._match_entity_request.body = request_body
        return self

    def build(self) -> MatchEntityRequest:
        return self._match_entity_request
