# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .abbreviation import Abbreviation
from .baike_image import BaikeImage
from .classification import Classification
from .referer import Referer


class RelatedMeta(object):
    _types = {
        "users": List[Referer],
        "chats": List[Referer],
        "docs": List[Referer],
        "oncalls": List[Referer],
        "links": List[Referer],
        "abbreviations": List[Abbreviation],
        "classifications": List[Classification],
        "images": List[BaikeImage],
    }

    def __init__(self, d=None):
        self.users: Optional[List[Referer]] = None
        self.chats: Optional[List[Referer]] = None
        self.docs: Optional[List[Referer]] = None
        self.oncalls: Optional[List[Referer]] = None
        self.links: Optional[List[Referer]] = None
        self.abbreviations: Optional[List[Abbreviation]] = None
        self.classifications: Optional[List[Classification]] = None
        self.images: Optional[List[BaikeImage]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RelatedMetaBuilder":
        return RelatedMetaBuilder()


class RelatedMetaBuilder(object):
    def __init__(self) -> None:
        self._related_meta = RelatedMeta()

    def users(self, users: List[Referer]) -> "RelatedMetaBuilder":
        self._related_meta.users = users
        return self

    def chats(self, chats: List[Referer]) -> "RelatedMetaBuilder":
        self._related_meta.chats = chats
        return self

    def docs(self, docs: List[Referer]) -> "RelatedMetaBuilder":
        self._related_meta.docs = docs
        return self

    def oncalls(self, oncalls: List[Referer]) -> "RelatedMetaBuilder":
        self._related_meta.oncalls = oncalls
        return self

    def links(self, links: List[Referer]) -> "RelatedMetaBuilder":
        self._related_meta.links = links
        return self

    def abbreviations(self, abbreviations: List[Abbreviation]) -> "RelatedMetaBuilder":
        self._related_meta.abbreviations = abbreviations
        return self

    def classifications(self, classifications: List[Classification]) -> "RelatedMetaBuilder":
        self._related_meta.classifications = classifications
        return self

    def images(self, images: List[BaikeImage]) -> "RelatedMetaBuilder":
        self._related_meta.images = images
        return self

    def build(self) -> "RelatedMeta":
        return self._related_meta
