# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .app_role_block_role import AppRoleBlockRole
from .app_role_table_role import AppRoleTableRole


class AppRole(object):
    _types = {
        "role_name": str,
        "role_id": str,
        "table_roles": List[AppRoleTableRole],
        "block_roles": List[AppRoleBlockRole],
    }

    def __init__(self, d=None):
        self.role_name: Optional[str] = None
        self.role_id: Optional[str] = None
        self.table_roles: Optional[List[AppRoleTableRole]] = None
        self.block_roles: Optional[List[AppRoleBlockRole]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppRoleBuilder":
        return AppRoleBuilder()


class AppRoleBuilder(object):
    def __init__(self) -> None:
        self._app_role = AppRole()

    def role_name(self, role_name: str) -> "AppRoleBuilder":
        self._app_role.role_name = role_name
        return self

    def role_id(self, role_id: str) -> "AppRoleBuilder":
        self._app_role.role_id = role_id
        return self

    def table_roles(self, table_roles: List[AppRoleTableRole]) -> "AppRoleBuilder":
        self._app_role.table_roles = table_roles
        return self

    def block_roles(self, block_roles: List[AppRoleBlockRole]) -> "AppRoleBuilder":
        self._app_role.block_roles = block_roles
        return self

    def build(self) -> "AppRole":
        return self._app_role
