# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AppRoleMember(object):
    _types = {
        "member_id": str,
        "open_id": str,
        "union_id": str,
        "user_id": str,
        "chat_id": str,
        "department_id": str,
        "open_department_id": str,
        "member_name": str,
        "member_en_name": str,
        "member_type": str,
    }

    def __init__(self, d=None):
        self.member_id: Optional[str] = None
        self.open_id: Optional[str] = None
        self.union_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.chat_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.open_department_id: Optional[str] = None
        self.member_name: Optional[str] = None
        self.member_en_name: Optional[str] = None
        self.member_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppRoleMemberBuilder":
        return AppRoleMemberBuilder()


class AppRoleMemberBuilder(object):
    def __init__(self) -> None:
        self._app_role_member = AppRoleMember()

    def member_id(self, member_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.member_id = member_id
        return self

    def open_id(self, open_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.open_id = open_id
        return self

    def union_id(self, union_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.union_id = union_id
        return self

    def user_id(self, user_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.user_id = user_id
        return self

    def chat_id(self, chat_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.chat_id = chat_id
        return self

    def department_id(self, department_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.department_id = department_id
        return self

    def open_department_id(self, open_department_id: str) -> "AppRoleMemberBuilder":
        self._app_role_member.open_department_id = open_department_id
        return self

    def member_name(self, member_name: str) -> "AppRoleMemberBuilder":
        self._app_role_member.member_name = member_name
        return self

    def member_en_name(self, member_en_name: str) -> "AppRoleMemberBuilder":
        self._app_role_member.member_en_name = member_en_name
        return self

    def member_type(self, member_type: str) -> "AppRoleMemberBuilder":
        self._app_role_member.member_type = member_type
        return self

    def build(self) -> "AppRoleMember":
        return self._app_role_member
