# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AppTable(object):
    _types = {
        "table_id": str,
        "revision": int,
        "name": str,
    }

    def __init__(self, d=None):
        self.table_id: Optional[str] = None
        self.revision: Optional[int] = None
        self.name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppTableBuilder":
        return AppTableBuilder()


class AppTableBuilder(object):
    def __init__(self) -> None:
        self._app_table = AppTable()

    def table_id(self, table_id: str) -> "AppTableBuilder":
        self._app_table.table_id = table_id
        return self

    def revision(self, revision: int) -> "AppTableBuilder":
        self._app_table.revision = revision
        return self

    def name(self, name: str) -> "AppTableBuilder":
        self._app_table.name = name
        return self

    def build(self) -> "AppTable":
        return self._app_table
