# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AppTableFormField(object):
    _types = {
        "field_id": str,
        "title": str,
        "description": str,
        "required": bool,
        "visible": bool,
    }

    def __init__(self, d=None):
        self.field_id: Optional[str] = None
        self.title: Optional[str] = None
        self.description: Optional[str] = None
        self.required: Optional[bool] = None
        self.visible: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppTableFormFieldBuilder":
        return AppTableFormFieldBuilder()


class AppTableFormFieldBuilder(object):
    def __init__(self) -> None:
        self._app_table_form_field = AppTableFormField()

    def field_id(self, field_id: str) -> "AppTableFormFieldBuilder":
        self._app_table_form_field.field_id = field_id
        return self

    def title(self, title: str) -> "AppTableFormFieldBuilder":
        self._app_table_form_field.title = title
        return self

    def description(self, description: str) -> "AppTableFormFieldBuilder":
        self._app_table_form_field.description = description
        return self

    def required(self, required: bool) -> "AppTableFormFieldBuilder":
        self._app_table_form_field.required = required
        return self

    def visible(self, visible: bool) -> "AppTableFormFieldBuilder":
        self._app_table_form_field.visible = visible
        return self

    def build(self) -> "AppTableFormField":
        return self._app_table_form_field
