# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_delete_app_table_record_request_body import BatchDeleteAppTableRecordRequestBody


class BatchDeleteAppTableRecordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.table_id: Optional[str] = None
        self.request_body: Optional[BatchDeleteAppTableRecordRequestBody] = None

    @staticmethod
    def builder() -> "BatchDeleteAppTableRecordRequestBuilder":
        return BatchDeleteAppTableRecordRequestBuilder()


class BatchDeleteAppTableRecordRequestBuilder(object):

    def __init__(self) -> None:
        batch_delete_app_table_record_request = BatchDeleteAppTableRecordRequest()
        batch_delete_app_table_record_request.http_method = HttpMethod.POST
        batch_delete_app_table_record_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/:table_id/records/batch_delete"
        batch_delete_app_table_record_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._batch_delete_app_table_record_request: BatchDeleteAppTableRecordRequest = batch_delete_app_table_record_request

    def app_token(self, app_token: str) -> "BatchDeleteAppTableRecordRequestBuilder":
        self._batch_delete_app_table_record_request.app_token = app_token
        self._batch_delete_app_table_record_request.paths["app_token"] = str(app_token)
        return self

    def table_id(self, table_id: str) -> "BatchDeleteAppTableRecordRequestBuilder":
        self._batch_delete_app_table_record_request.table_id = table_id
        self._batch_delete_app_table_record_request.paths["table_id"] = str(table_id)
        return self

    def request_body(self,
                     request_body: BatchDeleteAppTableRecordRequestBody) -> "BatchDeleteAppTableRecordRequestBuilder":
        self._batch_delete_app_table_record_request.request_body = request_body
        self._batch_delete_app_table_record_request.body = request_body
        return self

    def build(self) -> BatchDeleteAppTableRecordRequest:
        return self._batch_delete_app_table_record_request
