# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_delete_app_table_request_body import BatchDeleteAppTableRequestBody


class BatchDeleteAppTableRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.app_token: Optional[str] = None
        self.request_body: Optional[BatchDeleteAppTableRequestBody] = None

    @staticmethod
    def builder() -> "BatchDeleteAppTableRequestBuilder":
        return BatchDeleteAppTableRequestBuilder()


class BatchDeleteAppTableRequestBuilder(object):

    def __init__(self) -> None:
        batch_delete_app_table_request = BatchDeleteAppTableRequest()
        batch_delete_app_table_request.http_method = HttpMethod.POST
        batch_delete_app_table_request.uri = "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
        batch_delete_app_table_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._batch_delete_app_table_request: BatchDeleteAppTableRequest = batch_delete_app_table_request

    def app_token(self, app_token: str) -> "BatchDeleteAppTableRequestBuilder":
        self._batch_delete_app_table_request.app_token = app_token
        self._batch_delete_app_table_request.paths["app_token"] = str(app_token)
        return self

    def request_body(self, request_body: BatchDeleteAppTableRequestBody) -> "BatchDeleteAppTableRequestBuilder":
        self._batch_delete_app_table_request.request_body = request_body
        self._batch_delete_app_table_request.body = request_body
        return self

    def build(self) -> BatchDeleteAppTableRequest:
        return self._batch_delete_app_table_request
