# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class Condition(object):
    _types = {
        "field_name": str,
        "operator": str,
        "value": List[str],
    }

    def __init__(self, d=None):
        self.field_name: Optional[str] = None
        self.operator: Optional[str] = None
        self.value: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ConditionBuilder":
        return ConditionBuilder()


class ConditionBuilder(object):
    def __init__(self) -> None:
        self._condition = Condition()

    def field_name(self, field_name: str) -> "ConditionBuilder":
        self._condition.field_name = field_name
        return self

    def operator(self, operator: str) -> "ConditionBuilder":
        self._condition.operator = operator
        return self

    def value(self, value: List[str]) -> "ConditionBuilder":
        self._condition.value = value
        return self

    def build(self) -> "Condition":
        return self._condition
